import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../util/processResponse.js";

const initialState = {
    data: {},
    cartLoading: false,
    message: "",
    totalProduct: 0,
};

export const storeItemInCart = createAsyncThunk(
    "cart/storeItemInCart",
    async (obj) => {
        const { access_token, storeItemInCartUrl, cartData } = obj;
        const response = await mutationResponse(
            storeItemInCartUrl,
            "POST",
            cartData,
            access_token
        );
        return response;
    }
);

export const storeItemInCartDataProcess = (res) => {
    const {
        status: { code, message: errorMessage } = {},
        records: { data: { message, totalProduct } = {} } = {},
    } = res || {};
    if (code === 200) {
        return { code, message, totalProduct };
    } else {
        return {
            code,
            message: errorMessage,
            totalProduct: initialState.totalProduct,
        };
    }
};

const storeItemInCartSlice = createSlice({
    name: "cart",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(storeItemInCart.pending, (state) => {
            state.cartLoading = true;
        });
        builder.addCase(storeItemInCart.fulfilled, (state, { payload }) => {
            const { message, totalProduct } =
                storeItemInCartDataProcess(payload);
            state.cartLoading = false;
            state.message = message;
            state.totalProduct = totalProduct;
        });
        builder.addCase(storeItemInCart.rejected, (state) => {
            state.cartLoading = false;
        });
    },
});

export default storeItemInCartSlice.reducer;
